# 1 "/home/dim/src/head/crypto/openssh/smult_curve25519_ref.c"
# 1 "<built-in>" 1
# 1 "<built-in>" 3
# 329 "<built-in>" 3
# 1 "<command line>" 1
# 1 "<built-in>" 2
# 1 "/home/dim/src/head/crypto/openssh/ssh_namespace.h" 1
# 2 "<built-in>" 2
# 1 "/home/dim/src/head/crypto/openssh/krb5_config.h" 1
# 3 "<built-in>" 2
# 1 "/home/dim/src/head/crypto/openssh/smult_curve25519_ref.c" 2








int Fssh_crypto_scalarmult_curve25519(unsigned char *, const unsigned char *, const unsigned char *);

static void add(unsigned int out[32],const unsigned int a[32],const unsigned int b[32])
{
  unsigned int j;
  unsigned int u;
  u = 0;
  for (j = 0;j < 31;++j) { u += a[j] + b[j]; out[j] = u & 255; u >>= 8; }
  u += a[31] + b[31]; out[31] = u;
}

static void sub(unsigned int out[32],const unsigned int a[32],const unsigned int b[32])
{
  unsigned int j;
  unsigned int u;
  u = 218;
  for (j = 0;j < 31;++j) {
    u += a[j] + 65280 - b[j];
    out[j] = u & 255;
    u >>= 8;
  }
  u += a[31] - b[31];
  out[31] = u;
}

static void squeeze(unsigned int a[32])
{
  unsigned int j;
  unsigned int u;
  u = 0;
  for (j = 0;j < 31;++j) { u += a[j]; a[j] = u & 255; u >>= 8; }
  u += a[31]; a[31] = u & 127;
  u = 19 * (u >> 7);
  for (j = 0;j < 31;++j) { u += a[j]; a[j] = u & 255; u >>= 8; }
  u += a[31]; a[31] = u;
}

static const unsigned int minusp[32] = {
 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128
} ;

static void freeze(unsigned int a[32])
{
  unsigned int aorig[32];
  unsigned int j;
  unsigned int negative;

  for (j = 0;j < 32;++j) aorig[j] = a[j];
  add(a,a,minusp);
  negative = -((a[31] >> 7) & 1);
  for (j = 0;j < 32;++j) a[j] ^= negative & (aorig[j] ^ a[j]);
}

static void Fssh_mult(unsigned int out[32],const unsigned int a[32],const unsigned int b[32])
{
  unsigned int i;
  unsigned int j;
  unsigned int u;

  for (i = 0;i < 32;++i) {
    u = 0;
    for (j = 0;j <= i;++j) u += a[j] * b[i - j];
    for (j = i + 1;j < 32;++j) u += 38 * a[j] * b[i + 32 - j];
    out[i] = u;
  }
  squeeze(out);
}

static void mult121665(unsigned int out[32],const unsigned int a[32])
{
  unsigned int j;
  unsigned int u;

  u = 0;
  for (j = 0;j < 31;++j) { u += 121665 * a[j]; out[j] = u & 255; u >>= 8; }
  u += 121665 * a[31]; out[31] = u & 127;
  u = 19 * (u >> 7);
  for (j = 0;j < 31;++j) { u += out[j]; out[j] = u & 255; u >>= 8; }
  u += out[j]; out[j] = u;
}

static void Fssh_square(unsigned int out[32],const unsigned int a[32])
{
  unsigned int i;
  unsigned int j;
  unsigned int u;

  for (i = 0;i < 32;++i) {
    u = 0;
    for (j = 0;j < i - j;++j) u += a[j] * a[i - j];
    for (j = i + 1;j < i + 32 - j;++j) u += 38 * a[j] * a[i + 32 - j];
    u *= 2;
    if ((i & 1) == 0) {
      u += a[i / 2] * a[i / 2];
      u += 38 * a[i / 2 + 16] * a[i / 2 + 16];
    }
    out[i] = u;
  }
  squeeze(out);
}

static void select(unsigned int p[64],unsigned int q[64],const unsigned int r[64],const unsigned int s[64],unsigned int b)
{
  unsigned int j;
  unsigned int t;
  unsigned int bminus1;

  bminus1 = b - 1;
  for (j = 0;j < 64;++j) {
    t = bminus1 & (r[j] ^ s[j]);
    p[j] = s[j] ^ t;
    q[j] = r[j] ^ t;
  }
}

static void mainloop(unsigned int work[64],const unsigned char e[32])
{
  unsigned int xzm1[64];
  unsigned int xzm[64];
  unsigned int xzmb[64];
  unsigned int xzm1b[64];
  unsigned int xznb[64];
  unsigned int xzn1b[64];
  unsigned int a0[64];
  unsigned int a1[64];
  unsigned int b0[64];
  unsigned int b1[64];
  unsigned int c1[64];
  unsigned int r[32];
  unsigned int s[32];
  unsigned int t[32];
  unsigned int u[32];
  unsigned int j;
  unsigned int b;
  int pos;

  for (j = 0;j < 32;++j) xzm1[j] = work[j];
  xzm1[32] = 1;
  for (j = 33;j < 64;++j) xzm1[j] = 0;

  xzm[0] = 1;
  for (j = 1;j < 64;++j) xzm[j] = 0;

  for (pos = 254;pos >= 0;--pos) {
    b = e[pos / 8] >> (pos & 7);
    b &= 1;
    select(xzmb,xzm1b,xzm,xzm1,b);
    add(a0,xzmb,xzmb + 32);
    sub(a0 + 32,xzmb,xzmb + 32);
    add(a1,xzm1b,xzm1b + 32);
    sub(a1 + 32,xzm1b,xzm1b + 32);
    Fssh_square(b0,a0);
    Fssh_square(b0 + 32,a0 + 32);
    Fssh_mult(b1,a1,a0 + 32);
    Fssh_mult(b1 + 32,a1 + 32,a0);
    add(c1,b1,b1 + 32);
    sub(c1 + 32,b1,b1 + 32);
    Fssh_square(r,c1 + 32);
    sub(s,b0,b0 + 32);
    mult121665(t,s);
    add(u,t,b0);
    Fssh_mult(xznb,b0,b0 + 32);
    Fssh_mult(xznb + 32,s,u);
    Fssh_square(xzn1b,c1);
    Fssh_mult(xzn1b + 32,r,work);
    select(xzm,xzm1,xznb,xzn1b,b);
  }

  for (j = 0;j < 64;++j) work[j] = xzm[j];
}

static void recip(unsigned int out[32],const unsigned int z[32])
{
  unsigned int z2[32];
  unsigned int z9[32];
  unsigned int z11[32];
  unsigned int z2_5_0[32];
  unsigned int z2_10_0[32];
  unsigned int z2_20_0[32];
  unsigned int z2_50_0[32];
  unsigned int z2_100_0[32];
  unsigned int t0[32];
  unsigned int t1[32];
  int i;

          Fssh_square(z2,z);
          Fssh_square(t1,z2);
          Fssh_square(t0,t1);
          Fssh_mult(z9,t0,z);
           Fssh_mult(z11,z9,z2);
           Fssh_square(t0,z11);
                       Fssh_mult(z2_5_0,t0,z9);

                  Fssh_square(t0,z2_5_0);
                  Fssh_square(t1,t0);
                  Fssh_square(t0,t1);
                  Fssh_square(t1,t0);
                   Fssh_square(t0,t1);
                   Fssh_mult(z2_10_0,t0,z2_5_0);

                   Fssh_square(t0,z2_10_0);
                   Fssh_square(t1,t0);
                    for (i = 2;i < 10;i += 2) { Fssh_square(t0,t1); Fssh_square(t1,t0); }
                   Fssh_mult(z2_20_0,t1,z2_10_0);

                   Fssh_square(t0,z2_20_0);
                   Fssh_square(t1,t0);
                    for (i = 2;i < 20;i += 2) { Fssh_square(t0,t1); Fssh_square(t1,t0); }
                   Fssh_mult(t0,t1,z2_20_0);

                   Fssh_square(t1,t0);
                   Fssh_square(t0,t1);
                    for (i = 2;i < 10;i += 2) { Fssh_square(t1,t0); Fssh_square(t0,t1); }
                   Fssh_mult(z2_50_0,t0,z2_10_0);

                   Fssh_square(t0,z2_50_0);
                   Fssh_square(t1,t0);
                     for (i = 2;i < 50;i += 2) { Fssh_square(t0,t1); Fssh_square(t1,t0); }
                    Fssh_mult(z2_100_0,t1,z2_50_0);

                    Fssh_square(t1,z2_100_0);
                    Fssh_square(t0,t1);
                      for (i = 2;i < 100;i += 2) { Fssh_square(t1,t0); Fssh_square(t0,t1); }
                    Fssh_mult(t1,t0,z2_100_0);

                    Fssh_square(t0,t1);
                    Fssh_square(t1,t0);
                     for (i = 2;i < 50;i += 2) { Fssh_square(t0,t1); Fssh_square(t1,t0); }
                    Fssh_mult(t0,t1,z2_50_0);

                    Fssh_square(t1,t0);
                    Fssh_square(t0,t1);
                    Fssh_square(t1,t0);
                    Fssh_square(t0,t1);
                    Fssh_square(t1,t0);
                   Fssh_mult(out,t1,z11);
}

int Fssh_crypto_scalarmult_curve25519(unsigned char *q,
  const unsigned char *n,
  const unsigned char *p)
{
  unsigned int work[96];
  unsigned char e[32];
  unsigned int i;
  for (i = 0;i < 32;++i) e[i] = n[i];
  e[0] &= 248;
  e[31] &= 127;
  e[31] |= 64;
  for (i = 0;i < 32;++i) work[i] = p[i];
  mainloop(work,e);
  recip(work + 32,work + 32);
  Fssh_mult(work + 64,work,work + 32);
  freeze(work + 64);
  for (i = 0;i < 32;++i) q[i] = work[64 + i];
  return 0;
}
